"""empty message

Revision ID: e5f6be8a7b28
Revises: ca03ba18f2c0
Create Date: 2016-09-08 09:10:14.111387

"""

# revision identifiers, used by Alembic.
revision = 'e5f6be8a7b28'
down_revision = 'ca03ba18f2c0'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tb_global_alerts',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('alert_id', sa.Integer(), nullable=False),
    sa.Column('alert_state', sa.Integer(), nullable=False, default=-1),
    sa.Column('instance_id', sa.String(), nullable=False, default="N/A"),
    sa.Column('level', sa.Integer(), nullable=False),
    sa.Column('dispensable', sa.Integer(), nullable=False, default=1),
    sa.Column('is_unique', sa.Integer(), nullable=False, default=1),
    sa.Column('source_display_name', sa.String(), nullable=True),
    sa.Column('creation_time_in_utc', sa.DateTime(), nullable=False),
    sa.Column('last_update_time_in_utc', sa.DateTime(), nullable=False),
    sa.Column('reset', sa.Integer(), nullable=False),
    sa.Column('reset_period_in_hours', sa.Integer(), nullable=True, default=0),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_global_alerts')),
    sa.UniqueConstraint('alert_id', 'alert_state', 'instance_id', name='uq_tb_global_alerts_alert_id_alert_state_instance_id')
    )
    op.create_table('tb_cr_device_info',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('guid', sa.String(length=36), nullable=True),
    sa.Column('details_info', postgresql.JSON(), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_cr_device_info')),
    sa.UniqueConstraint('guid', name=op.f('uq_tb_cr_device_info_guid'))
    )
    op.create_table('tb_import_sources',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('source_type', sa.Integer(), nullable=False),
    sa.Column('server', sa.String(), nullable=True),
    sa.Column('port', sa.Integer(), nullable=True),
    sa.Column('username', sa.String(), nullable=True),
    sa.Column('password', sa.String(), nullable=True),
    sa.Column('path', sa.String(), nullable=False),
    sa.Column('image_name', sa.String(), nullable=False),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('modify_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_import_sources'))
    )
    op.create_table('tb_pr_info',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('ac', sa.String(), nullable=False),
    sa.Column('is_enabled', sa.Boolean(), nullable=True),
    sa.Column('product_code', sa.String(), nullable=False),
    sa.Column('version_type', sa.Integer, nullable=True),
    sa.Column('grace_period', sa.Integer, nullable=True),
    sa.Column('profile', sa.String(), nullable=False),
    sa.Column('expire_in_local', sa.String(), nullable=False),
    sa.Column('last_update_time_in_utc', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_pr_info'))
    )
    op.create_table('tb_import_tasks',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('uid', sa.String(), nullable=False),
    sa.Column('source_id', sa.BigInteger(), nullable=True),
    sa.Column('source_type', sa.Integer(), nullable=False),
    sa.Column('image_name', sa.String(), nullable=True),
    sa.Column('file_name', sa.String(), nullable=False),
    sa.Column('file_size', sa.BigInteger(), nullable=True),
    sa.Column('checksum', sa.String(), nullable=True),
    sa.Column('chunk_size', sa.BigInteger(), nullable=True),
    sa.Column('chunk_amount', sa.Integer(), nullable=True),
    sa.Column('source_chunk_index', sa.Integer(), nullable=True),
    sa.Column('target_chunk_index', sa.Integer(), nullable=True),
    sa.Column('source_state', sa.Integer(), nullable=True),
    sa.Column('target_state', sa.Integer(), nullable=True),
    sa.Column('state', sa.Integer(), nullable=True),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('creator', sa.BigInteger(), nullable=True),
    sa.Column('meta', postgresql.JSON(), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('modify_time', sa.DateTime(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['source_id'], ['tb_import_sources.id'], name=op.f('fk_tb_import_tasks_source_id_tb_import_sources')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_import_tasks')),
    sa.UniqueConstraint('uid', name=op.f('uq_tb_import_tasks_uid'))
    )
    op.create_index(op.f('ix_tb_audit_log_action_by'), 'tb_audit_log', ['action_by'], unique=False)
    op.create_index(op.f('ix_tb_audit_log_event_id'), 'tb_audit_log', ['event_id'], unique=False)
    op.create_index(op.f('ix_tb_audit_log_event_type'), 'tb_audit_log', ['event_type'], unique=False)
    op.create_index(op.f('ix_tb_audit_log_from_ip'), 'tb_audit_log', ['from_ip'], unique=False)
    op.create_index(op.f('ix_tb_audit_log_log_utc_time'), 'tb_audit_log', ['log_utc_time'], unique=False)
    op.create_index(op.f('ix_tb_audit_log_result'), 'tb_audit_log', ['result'], unique=False)
    op.create_index(op.f('ix_tb_audit_log_severity'), 'tb_audit_log', ['severity'], unique=False)
    op.add_column(u'tb_deployment_plan', sa.Column('by_execution_time', sa.Integer(), nullable=True))
    op.add_column(u'tb_deployment_plan', sa.Column('canceler_display_name', sa.String(), nullable=True))
    op.add_column(u'tb_deployment_plan', sa.Column('device_execution_time', sa.DateTime(), nullable=True))
    op.create_unique_constraint(op.f('uq_tb_deployment_plan_id'), 'tb_deployment_plan', ['id'])    
    op.add_column(u'tb_deployment_plan_task', sa.Column('is_source', sa.Integer(), nullable=True))
    op.create_unique_constraint(op.f('uq_tb_system_node_guid'), 'tb_system_node', ['guid'])
    op.add_column('tb_user_profile', sa.Column('username', sa.String(length=100), nullable=True))
    op.add_column('tb_user_profile', sa.Column('setting', postgresql.JSON(), nullable=True))
    op.add_column('tb_user_profile', sa.Column('default_setting', postgresql.JSON(), nullable=True))
    op.create_unique_constraint('uq_tb_user_profile_user_id_username_feature', 'tb_user_profile', ['user_id', 'username', 'feature'])
    op.drop_constraint(u'uq_tb_user_profile_guid', 'tb_user_profile', type_='unique')
    op.drop_column('tb_user_profile', 'guid')
    op.add_column('tb_users', sa.Column('email', sa.String(), nullable=True))
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('tb_users', 'email')
    op.add_column('tb_user_profile', sa.Column('guid', postgresql.UUID(), autoincrement=False, nullable=False))
    op.create_unique_constraint(u'uq_tb_user_profile_guid', 'tb_user_profile', ['guid'])
    op.drop_constraint('uq_tb_user_profile_user_id_username_feature', 'tb_user_profile', type_='unique')
    op.drop_column('tb_user_profile', 'username')
    op.drop_column('tb_user_profile', 'setting')
    op.drop_column('tb_user_profile', 'default_setting')
    op.drop_constraint(op.f('uq_tb_system_node_guid'), 'tb_system_node', type_='unique')
    op.drop_column(u'tb_deployment_plan_task', 'is_source')
    op.drop_constraint(op.f('uq_tb_deployment_plan_id'), 'tb_deployment_plan', type_='unique')
    op.drop_column(u'tb_deployment_plan', 'device_execution_time')
    op.drop_column(u'tb_deployment_plan', 'canceler_display_name')
    op.drop_column(u'tb_deployment_plan', 'by_execution_time')
    op.drop_index(op.f('ix_tb_audit_log_severity'), table_name='tb_audit_log')
    op.drop_index(op.f('ix_tb_audit_log_result'), table_name='tb_audit_log')
    op.drop_index(op.f('ix_tb_audit_log_log_utc_time'), table_name='tb_audit_log')
    op.drop_index(op.f('ix_tb_audit_log_from_ip'), table_name='tb_audit_log')
    op.drop_index(op.f('ix_tb_audit_log_event_type'), table_name='tb_audit_log')
    op.drop_index(op.f('ix_tb_audit_log_event_id'), table_name='tb_audit_log')
    op.drop_index(op.f('ix_tb_audit_log_action_by'), table_name='tb_audit_log')
    op.drop_table('tb_import_tasks')
    op.drop_table('tb_pr_info')
    op.drop_table('tb_import_sources')
    op.drop_table('tb_cr_device_info')
    op.drop_table('tb_global_alerts')
    ### end Alembic commands ###
